
(* Waits until the zone is ready (returns immediantly if zone is not activated) *)
FUNCTION_BLOCK PMC_AutoLoadingZon_HoldZoneReady
	IF Execute = TRUE THEN
		IF CmdSta = 0 THEN
			CmdSta := 1;
			Busy := TRUE;
			Done := FALSE;
			Error := FALSE;
			ErrorID := 0;
			Aborted := FALSE;
		END_IF;
	ELSE
		Done := FALSE;
		Error := FALSE;
		ErrorID := 0;
		Busy := FALSE;
		Aborted := FALSE;
		CmdSta := 0;
		(*reset the PMC_AutoLoadingZone_GetZoneStatus FB*)
		PMC_GetZoneStatus_db.Execute := FALSE;
		PMC_GetZoneStatus_db(PM_Controller := PM_Controller,ZoneID := ZoneID);
	END_IF;

	IF CmdSta = 1 THEN
		(*logic here to constantly trigger wait_for_xbot_to_appear until an xbot appears*)
		IF (Execute = TRUE AND xbot_is_in_zone_or_error = FALSE) THEN
			(*if not requesting the zone state start requesting it*)
			IF(PMC_GetZoneStatus_db.Execute = FALSE)THEN
				PMC_GetZoneStatus_db.Execute := TRUE;
			END_IF;
			(*if request received, and xbot is in yet, reset the request and prepare to ask again*)
			IF(PMC_GetZoneStatus_db.Execute = TRUE AND PMC_GetZoneStatus_db.Done = TRUE) THEN
				PMC_GetZoneStatus_db.Execute := FALSE;
			END_IF;
		END_IF;
		IF (Execute = FALSE) THEN
			PMC_GetZoneStatus_db.Execute := FALSE;
		END_IF;

		(*call the GetZoneStatus FB*)
		PMC_GetZoneStatus_db(PM_Controller := PM_Controller,ZoneID := ZoneID);
	
		(*if GetZoneStatus has returned ready, error, aborted, or zone not active copy the results to the output*)
		IF((PMC_GetZoneStatus_db.Done = TRUE AND (PMC_GetZoneStatus_db.EntranceExitState = 1 OR PMC_GetZoneStatus_db.ZoneState = 0 OR PMC_GetZoneStatus_db.ZoneState = 1)) OR (PMC_GetZoneStatus_db.Error OR PMC_GetZoneStatus_db.Aborted))THEN
			xbot_is_in_zone_or_error := TRUE;
			Done := PMC_GetZoneStatus_db.Done;
			Busy := PMC_GetZoneStatus_db.Busy;
			Aborted := PMC_GetZoneStatus_db.Aborted;
			Error := PMC_GetZoneStatus_db.Error;
			ErrorID := PMC_GetZoneStatus_db.ErrorID;
			ZoneState := PMC_GetZoneStatus_db.ZoneState;
			EntranceExitState := PMC_GetZoneStatus_db.EntranceExitState;
			numXbots := PMC_GetZoneStatus_db.numXbots;
			xbotID := PMC_GetZoneStatus_db.xbotID;
			ZoneX := PMC_GetZoneStatus_db.ZoneX;
			ZoneY := PMC_GetZoneStatus_db.ZoneY;
		ELSE
			xbot_is_in_zone_or_error := FALSE;
		END_IF;
	END_IF;
END_FUNCTION_BLOCK
